﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Graphs
{
    public partial class Form1 : Form
    {
        byte FuncNum = 1;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            FuncNum = 1;
            label2.Text = "a =";
            label3.Text = "b =";
            label4.Text = "c =";
            groupBox2.Visible = true;
            groupBox3.Visible = false;
            groupBox4.Visible = false;
            groupBox5.Visible = false;
        }
        private void RadioButton1_CheckedChanged(object sender, EventArgs e)
        {
            FuncNum = 1;
            label2.Text = "a =";
            label3.Text = "b =";
            label4.Text = "c =";
            groupBox2.Visible = true;
            groupBox3.Visible = false;
        }

        private void RadioButton2_CheckedChanged(object sender, EventArgs e)
        {
            FuncNum = 2;
            label5.Text = "n =";
            groupBox2.Visible = false;
            groupBox3.Visible = true;
        }

        private void RadioButton3_CheckedChanged(object sender, EventArgs e)
        {
            FuncNum = 3;
            label5.Text = "a =";
            groupBox2.Visible = false;
            groupBox3.Visible = true;
        }

        private void RadioButton4_CheckedChanged(object sender, EventArgs e)
        {
            FuncNum = 4;
            label2.Text = "A =";
            label3.Text = "ω =";
            label4.Text = "φ =";
            groupBox2.Visible = true;
            groupBox3.Visible = false;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            float xmin, xmax, ymin, ymax, kx, ky, xa, ya, x, y, y1, a, b, c;
            int n, nl, nr;

            Pen pen1 = new Pen(Color.Black, 1);
            Pen pen2 = new Pen(Color.LightGreen, 1);
            Pen pen3 = new Pen(Color.Red, 2);
            Brush brush1 = new SolidBrush(Color.Black);;
            Font font1 = new Font("Arial", 10);

            xmin = -15;
            xmax = 15;
            ymin = -15;
            ymax = 15;
            kx = 596 / (xmax - xmin); // коэффициенты преобразования координат
            ky = 596 / (ymax - ymin);

            label1.Visible = false;
            groupBox4.Visible = false;
            groupBox5.Visible = false;

            Graphics g = pictureBox1.CreateGraphics(); // начало построения изображения
            g.Clear(Color.White);

            g.ScaleTransform(1, -1);
            g.TranslateTransform(-xmin * kx + 2, -ymax * ky - 2);

        // построение сетки
            for (xa = xmin; xa <= xmax; xa++)  // вертикальные линии
            {
                g.DrawLine(pen2, kx * xa, ky * ymin, kx * xa, ky * ymax);
            }
        
            for (ya = xmin; ya <= xmax; ya++) // горизонтальные линии
            {
                g.DrawLine(pen2, kx * xmin, ky * ya, kx * xmax, ky * ya);
            }

        // построение осей координат
            g.DrawLine(pen1, kx * xmin, ky * (ymax + ymin) / 2, kx * xmax, ky * (ymax + ymin) / 2); // ось х
            g.DrawLine(pen1, kx * (xmax + xmin) / 2, ky * ymin, kx * (xmax + xmin) / 2, ky * ymax); // ось у

            g.ScaleTransform(1, -1);
            for (xa = kx * xmin; xa <= kx * xmax; xa += kx * (xmax - xmin) / 6) // шкала на оcи х
            {
                g.DrawString(Math.Round(xa / kx).ToString(), font1, brush1, xa - 10, -ky * (ymax + ymin) / 2 + 5);
            }
        
            for (ya = ky * ymin; ya<= ky * ymax; ya += ky * (ymax - ymin) / 6) // шкала на оcи у
            {
                if (Math.Round(ya / ky) != 0)
                {
                    g.DrawString(Math.Round(ya / ky).ToString(), font1, brush1, kx * (xmax + xmin) / 2 + 5, -ya - 8);
                }
            }
            g.ScaleTransform(1, -1);

        // построение графиков
            switch (FuncNum)
            {
                case 1: // y = ax ^ 2 + bx + c
                    try
                    {
                        a = Single.Parse(textBox1.Text);
                        b = Single.Parse(textBox2.Text);
                        c = Single.Parse(textBox3.Text);
                        if (a != 0)
                        {
                            for (x = xmin; x <= xmax; x += 0.1F)
                            {
                                y = a * x * x + b * x + c;
                                y1 = a * (x + 0.1F) * (x + 0.1F) + b * (x + 0.1F) + c;
                                g.DrawLine(pen3, kx * x, ky * y, kx * (x + 0.1F), ky * y1);// построение отрезка графика
                            }
                            float x0, y0, x1, x2, d;  // определение экстремумов и корней
                            x0 = -b / (2 * a);
                            y0 = a * x0 * x0 + b * x0 + c;
                            g.FillEllipse(Brushes.DeepSkyBlue, kx * x0 - 3, ky * y0 - 3, 7, 7);
                            if (a > 0) { label6.Text = "Экстремум: x_min = " + x0 + "; y_min = " + y0; }
                            if (a < 0) { label6.Text = "Экстремум: x_max = " + x0 + "; y_max = " + y0; }
                            d = b * b - 4 * a * c;
                            if (d >= 0)
                            {
                                x1 = Convert.ToSingle((-b - Math.Sqrt(d)) / (2 * a));
                                x2 = Convert.ToSingle((-b + Math.Sqrt(d)) / (2 * a));
                                g.FillEllipse(Brushes.Lime, kx * x1 - 3, -3, 7, 7);
                                g.FillEllipse(Brushes.Lime, kx * x2 - 3, -3, 7, 7);
                                if (d > 0)
                                {
                                    label7.Text = "Корни: x = " + x1 + "; x = " + x2;
                                }
                                else
                                {
                                    label7.Text = "Корень: x = " + x1;
                                }
                            }
                            else
                            {
                                label7.Text = "Корней нет";
                            }
                            groupBox4.Visible = true;
                            groupBox5.Visible = false;
                        }
                        else
                        {
                            label1.Visible = true;
                        }
                    }
                    catch (FormatException)
                    {
                        label1.Visible = true;
                    }
                    
                    break;

                case 2: // y = x ^ n
                    try
                    {
                        a = Single.Parse(textBox4.Text);
                        if ((a > 0) && (Math.Truncate(a) == a))
                        {
                            for (x = xmin + 4 * Convert.ToSingle(Math.Log(a)); x <= xmax - 4 * Convert.ToSingle(Math.Log(a)); x += 0.1F)
                            {
                                y = Convert.ToSingle(Math.Pow(x, a));
                                y1 = Convert.ToSingle(Math.Pow(x + 0.1, a));
                                g.DrawLine(pen3, kx * x, ky * y, kx * (x + 0.1F), ky * y1); // построение отрезка графика
                            }
                            label7.Text = "Корень: х = 0"; // определение экстремумов и корней
                            g.FillEllipse(Brushes.Lime, -3, -3, 7, 7);
                            if (a % 2 == 0)
                            {
                                label6.Text = "Экстремум: x_min = 0; y_min = 0";
                            }
                            else
                            {
                                label6.Text = "Экстремумы: нет";
                            }
                            groupBox4.Visible = true;
                            groupBox5.Visible = false;
                        }
                        else
                        {
                            label1.Visible = true;
                        }
                    }
                    catch (FormatException)
                    {
                        label1.Visible = true;
                    }
                    break;

                case 3: // y = a ^ x
                    try
                    {
                        a = Single.Parse(textBox4.Text);
                        if (a > 0)
                        {
                            for (x = xmin - 5 * Convert.ToSingle(Math.Log(a)); x <= xmax - 5 * Convert.ToSingle(Math.Log(a)); x += 0.1F)
                            {
                                y = Convert.ToSingle(Math.Pow(a, x));
                                y1 = Convert.ToSingle(Math.Pow(a, x + 0.1));
                                g.DrawLine(pen3, kx * x, ky * y, kx * (x + 0.1F), ky * y1); // построение отрезка графика
                            }
                            label6.Text = "Экстремумы: нет"; // определение экстремумов и корней
                            label7.Text = "Корни: нет";
                            groupBox4.Visible = true;
                            groupBox5.Visible = false;
                        }
                        else
                        {
                            label1.Visible = true;
                        }
                        }
                        catch (FormatException)
                        {
                            label1.Visible = true;
                        }
                        break;

                default: // y = Asin(ωx + φ)
                    try
                    {
                        a = Single.Parse(textBox1.Text);
                        b = Single.Parse(textBox2.Text);
                        c = Single.Parse(textBox3.Text);
                        if ((a != 0) && (b > 0))
                        {
                            for (x = xmin; x <= xmax; x += 0.1F)
                            {
                                y = Convert.ToSingle(a * Math.Sin(b * x + c));
                                y1 = Convert.ToSingle(a * Math.Sin(b * (x + 0.1) + c));
                                g.DrawLine(pen3, kx * x, ky * y, kx * (x + 0.1F), ky * y1); // построение отрезка графика
                            }

                            nl = Convert.ToInt16(Math.Ceiling(((xmin * b + c) / Math.PI - 0.5) / 2)); // определение экстремумов
                            nr = Convert.ToInt16(Math.Floor(((xmax * b + c) / Math.PI - 0.5) / 2));
                            String smin = "";
                            String smax = "";
                            for (n = nl; n <= nr; n++)
                            {
                                x = Convert.ToSingle(((-c + Math.PI * (-0.5 + 2 * n)) / b));
                                g.FillEllipse(Brushes.DeepSkyBlue, kx * x - 3, ky * (-a) - 3, 7, 7);
                                if (a > 0)
                                {
                                    smin += "x_min = " + x + "; y_min = -" + a + "\r\n";
                                }
                                else
                                {
                                    smax += "x_max = " + x + "; y_max = " + Math.Abs(a) + "\r\n";
                                }
                            }
                            for (n = nl; n <= nr; n++)
                            {
                                x = Convert.ToSingle(((-c + Math.PI * (0.5 + 2 * n)) / b));
                                g.FillEllipse(Brushes.DeepSkyBlue, kx * x - 3, ky * a - 3, 7, 7);
                                if (a > 0)
                                {
                                    smax += "x_max = " + x + "; y_max = " + a + "\r\n";
                                }
                                else
                                {
                                    smin += "x_min = " + x + "; y_min = " + a + "\r\n";
                                }
                            }
                            textBox5.Text = smin + smax;

                            nl = Convert.ToInt16(Math.Ceiling((xmin * b + c) / Math.PI)); // определение корней
                            nr = Convert.ToInt16(Math.Floor((xmax * b + c) / Math.PI));
                            String root = "";
                            for (n = nl; n <= nr; n++)
                            {
                                x = Convert.ToSingle(((-c + Math.PI * n) / b));
                                g.FillEllipse(Brushes.Lime, kx * x - 3, -3, 7, 7);
                                root += "x = " + x + "\r\n";
                            }
                            textBox6.Text = root;
                            groupBox4.Visible = false;
                            groupBox5.Visible = true;
                        }
                        else
                        {
                            label1.Visible = true;
                        }
                    }
                    catch (FormatException)
                    {
                        label1.Visible = true;
                    }
                    break;
            }
        }
    }
}
